<?php

namespace app\controllers;

use Yii;
use yii\filters\AccessControl;
use yii\web\Controller;
use yii\web\Response;
use yii\filters\VerbFilter;
use yii\data\Pagination;
use app\models\User;
use app\models\active\{Business,
    Items,
    Journal,
    Mybusiness,
    Mail,
    Setting,
    Chat,
    Dialog,
    Icons,
    Usericons,
    Gift,
    Giftuser,
    Corp,
    Avatar,
    Quest,
    Achievements,
    Friends,
    Tourneyuser
};
use yii\helpers\Html;

class UserController extends Controller
{
    public function behaviors()
    {
        return [
            'access' => [
                'class' => AccessControl::className(),
                'rules' => [
                    [
                        'allow' => true,
                        'roles' => ['@'],
                        'denyCallback' => function ($rule, $action) {
                            return $this->redirect(['/site/index']);
                        }
                    ],
                ],
            ],
        ];
    }


    public function actionFriends()
    {


        $query = Friends:: find()->where(['user' => Yii::$app->user->id]);

        $pagination = new Pagination([
            'defaultPageSize' => 10,
            'totalCount' => $query->count(),
        ]);

        $all = $query->orderBy('id DESC')
            ->offset($pagination->offset)
            ->limit($pagination->limit)
            ->all();

        return $this->render('friends',
            [
                'count' => $query->count(),
                'pagination' => $pagination,
                'all' => $all,
            ]

        );


    }


    public function actionIndex($id = null, $dumpAvatar = null)
    {

        $user = User:: findOne($id);

        if (!isset($user->id)) return $this->goHome();

        $trn = Tourneyuser:: findOne(['user' => $user->id]);

        $ach = Achievements:: find()->where(['user' => $user->id, 'reward' => '1'])->orderBy('id desc')->limit(12);

        $gifts = Giftuser:: find()->where(['user' => $user->id])->orderBy('id desc')->limit(5);
        $corp = !empty($user->corp) ? Corp::findOne($user->corp) : null;


        if ($user->id != Yii::$app->user->id) {

            $myuser = User:: findOne(Yii::$app->user->id);

            $invite = null;

            if (isset($corp->id)) {

                if ($corp->user == $myuser->id) {

                    $invite = 1;
                }


            }

            $business = Mybusiness:: find()->where(['user' => $user->id])->all();

            $friends = Friends:: findOne(['user' => Yii::$app->user->id, 'who' => $user->id]);

            $settings = \app\models\active\Setting:: findOne(1);


            return $this->render('user', [
                'user' => $user,
                'business' => $business,
                'star' => 1,
                'friends' => $friends,
                'gifts' => $gifts,
                'invite' => $invite,
                'ach' => $ach,
                'trn' => $trn,
                'settings' => $settings,
                'corp' => $corp
            ]);

        } else {

            //-- Настройки вещей
            $config = Yii::$app->params['items_param'];
            $items = Items::find()->where(['user_id' => $user->id])->all();

            $model = new \app\models\form\SaveUser();


            if ($model->load(Yii::$app->request->post()) && $model->validate()) {

                $user->secret_word = mb_strtolower($model->secret_word);
                $user->username = $model->username;
                $user->ruby = $user->ruby + 100;
                $user->password = Yii::$app->getSecurity()->generatePasswordHash($model->password);

                $user->save();

                User:: Notice(['status' => 'success', 'title' => 'Игрок успешно сохранен! Награда 100 рубинов']);
                return $this->redirect('/user/' . $user->id);
            }

            /**
             * Сброс аватара
             * @author Oleg Kulaga (Medan)
             */
            if (isset($dumpAvatar)) {
                if ($user->avatar == 0) {
                    User:: Notice(['status' => 'error', 'title' => 'У вас уже установлен стандартный аватар']);
                    return $this->redirect('/user/' . $user->id);
                } else {
                    $user->avatar = 0;
                    $user->save();

                    User:: Notice(['status' => 'success', 'title' => 'Стандартный аватар установлен успешно']);
                    return $this->redirect('/user/' . $user->id);
                }
            }

            return $this->render('index', [
                'user' => $user,
                'model' => $model,
                'star' => 1,
                'gifts' => $gifts,
                'ach' => $ach,
                'trn' => $trn,
                'corp' => $corp,
                'config' => $config,
                'items' => $items
            ]);
        }
    }

    public function actionMail()
    {
        if (Yii::$app->user->isGuest) return $this->goHome();

        $user = User::findOne(Yii::$app->user->id);

        $query = Dialog:: find()->where(['user' => Yii::$app->user->id]);

        $pagination = new Pagination([
            'defaultPageSize' => 10,
            'totalCount' => $query->count(),
        ]);

        $all = $query->orderBy('id DESC')
            ->offset($pagination->offset)
            ->limit($pagination->limit)
            ->all();

        return $this->render('mail',
            [
                'count' => $query->count(),
                'pagination' => $pagination,
                'all' => $all,
            ]

        );

    }


    public function actionMailview()
    {
        if (Yii::$app->user->isGuest) return $this->goHome();

        $user = User::findOne(Yii::$app->user->id);

        $who = User:: findOne(Yii::$app->request->get('id'));

        if (!isset($who->id) or Yii::$app->request->get('id') == Yii::$app->user->id) return $this->goHome();


        Mail::updateAll(['_read' => '0'], ['who' => $user->id, '_read' => '1', 'user' => $who->id]);
        Dialog::updateAll(['_read' => '0'], ['user' => $user->id, 'who' => $who->id]);

        $query = Mail::find()->where(
            ['user' => $user->id, 'who' => $who->id]
        )->orWhere(
            ['user' => $who->id, 'who' => $user->id]
        )->andWhere(['_del' => '0']);

        $pagination = new Pagination([
            'defaultPageSize' => 10,
            'totalCount' => $query->count(),
        ]);

        $all = $query->orderBy('id DESC')
            ->offset($pagination->offset)
            ->limit($pagination->limit)
            ->all();

        $model = new \app\models\form\Mail();

        $countDialog = Dialog:: find()->where(['user' => $user->id])->andWhere(['>', '_update', date('Y-m-d H:m:s', time() - 86400)])->count();

        if ($model->load(Yii::$app->request->post()) && $model->validate()) {


            if (User:: BusinessCount() < 5 && $user->role == 0 && $who->role == 0 && empty($user->dump_business)) {

                User:: Notice(['title' => 'Для отправки сообщения необходимо открыть 5 бизнесов', 'status' => 'error']);
                return $this->goBack();

            }

            if ($countDialog >= 5 && $user->role == 0) {

                User:: Notice(['title' => 'Антиспам - в день можно писать только 5ти игрокам', 'status' => 'error']);
                return $this->goBack();

            }

            $dialog = Dialog::find()->where(
                ['user' => $user->id, 'who' => $who->id]
            )->orWhere(
                ['user' => $who->id, 'who' => $user->id]
            );

            if ($dialog->count() == 0) {


                $dialog_user = new Dialog();
                $dialog_user->user = $user->id;
                $dialog_user->who = $who->id;
                $dialog_user->save();

                $dialog_who = new Dialog();
                $dialog_who->who = $user->id;
                $dialog_who->user = $who->id;
                $dialog_who->save();

            }


            $mail = new Mail();
            $mail->user = $user->id;
            $mail->who = $who->id;
            $mail->text = $model->text;
            $mail->save();

            Dialog::updateAll(['_read' => '1'], ['who' => $user->id, 'user' => $who->id]);


            return $this->redirect('/user/mail/view/' . $who->id);


        }


        return $this->render('mailview',
            ['pagination' => $pagination,
                'all' => $all,
                'count' => $query->count(),
                'who' => $who,
                'model' => $model,
                'emoji' => \app\models\active\Chat:: Emoji(),
                'emojihead' => \app\models\active\Chat:: EmojiHead(),
            ]);

    }

    public function actionRating($type = 0)
    {

        if (!in_array($type, [0, 1, 2])) $type = 0;


        $rateArray = [

            ['name' => 'доходу', 'desc' => 'income', 'icon' => '/images/header/money_36.png'],
            ['name' => 'самому прибыльному бизнесу', 'desc' => 'business', 'icon' => '/images/header/money_36.png'],
            ['name' => 'активности', 'desc' => 'time', 'icon' => '/images/icons/clock.png'],


        ];


        $query = User:: find();

        $pagination = new Pagination([
            'defaultPageSize' => 10,
            'totalCount' => $query->count(),
        ]);

        $all = $query->orderBy($rateArray[$type]['desc'] . ' desc')
            ->offset($pagination->offset)
            ->limit($pagination->limit)
            ->all();

        $count = ($pagination->getPage() + 1) > 1 ? ($pagination->getPage() + 1) * 10 - 9 : 1;

        return $this->render('rating',
            [
                'pagination' => $pagination,
                'all' => $all,
                'count' => $count,
                'rateArray' => $rateArray,
                'type' => $type,
            ]

        );


    }


    public function actionSetting()
    {
        /*
        $model = new \app\models\form\StyleChange();
        if ($model->load(Yii::$app->request->post()) && $model->change()) {
            User:: Notice(['status' => 'success', 'title' => 'Стиль успешно изменен']);
            return $this->redirect('/user/setting');
        }
        */
        return $this->render('setting');
    }


    public function actionPasswordChange()
    {

        $model = new \app\models\form\PasswordChange();

        if ($model->load(Yii::$app->request->post()) && $model->change()) {

            User:: Notice(['status' => 'success', 'title' => 'Пароль успешно изменен']);
            return $this->redirect('/user/password-change');

        }

        return $this->render('password-change', ['model' => $model]);


    }

    public function actionNickChange()
    {

        $model = new \app\models\form\NickChange();
        $user = User:: findOne(Yii::$app->user->id);

        $model->username = $user->username;

        if ($model->load(Yii::$app->request->post()) && $model->validate()) {

            if ($user->ruby < 200) {

                User:: Notice(['status' => 'error', 'title' => 'Недостаточно рубинов']);
                return $this->redirect('/user/nick-change');

            }

            $user->username = $model->username;
            $user->ruby = $user->ruby - 200;
            $user->save();

            User:: Notice(['status' => 'success', 'title' => 'Ник успешно изменен']);
            return $this->redirect('/user/nick-change');

        }

        return $this->render('nick-change', ['model' => $model]);

    }

    public function actionStatusChange()
    {
        $model = new \app\models\form\EditUserStatus();
        $user = User::findOne(Yii::$app->user->id);
        $status = Html::encode($user->text_status);

        if ($model->load(Yii::$app->request->post()) && $model->validate()) {

            $user->text_status = $model->user_status;
            $user->save();

            User:: Notice(['status' => 'success', 'title' => 'Статус успешно изменен']);
            return $this->redirect('/user/status-change');

        }

        return $this->render('status-change', [
            'model' => $model,
            'status' => $status
        ]);
    }


    public function actionSexChange()
    {

        $model = new \app\models\form\SexChange();
        $user = User:: findOne(Yii::$app->user->id);

        $model->sex = $user->sex;

        if ($model->load(Yii::$app->request->post()) && $model->validate()) {


            $user->sex = $model->sex;
            $user->save();

            User:: Notice(['status' => 'success', 'title' => 'Пол успешно изменен']);
            return $this->redirect('/user/sex-change');

        }

        return $this->render('sex-change', ['model' => $model]);

    }


    public function actionEmailChange()
    {

        $model = new \app\models\form\EmailChange();
        $user = User:: findOne(Yii::$app->user->id);

        $model->email = $user->email;

        if ($model->load(Yii::$app->request->post()) && $model->validate()) {


            $user->email = $model->email;
            $user->save();

            User:: Notice(['status' => 'success', 'title' => 'E-Mail успешно изменен']);
            return $this->redirect('/user/email-change');

        }

        return $this->render('email-change', ['model' => $model]);

    }

    public function actionPayment($ruby = null)
    {
        //-- Ищем текущую акцию
        $action = \app\models\active\Action:: Week();

        //-- Грузим цены с конфига
        $price = Yii::$app->params['payment'];

        return $this->render('payment', [
            'price' => $price,
            'action' => $action
        ]);


    }

    public function actionOnline($corp = 0)
    {

        $setting = \app\models\active\Setting::findOne(1);

        $query = User:: find()->where(['>', 'online', time() - $setting->online]);

        if ($corp == 1) $query->andWhere(['corp' => '0']);

        $pagination = new Pagination([
            'defaultPageSize' => 10,
            'totalCount' => $query->count(),
        ]);

        $all = $query->orderBy('online desc')
            ->offset($pagination->offset)
            ->limit($pagination->limit)
            ->all();

        $count = ($pagination->getPage() + 1) > 1 ? ($pagination->getPage() + 1) * 10 - 9 : 1;

        return $this->render('online',
            [
                'pagination' => $pagination,
                'all' => $all,
                'count' => $count,
                'corp' => $corp,
            ]

        );


    }


    public function actionAdmin()
    {


        $query = User:: find()->where(['>', 'role', '0']);

        $pagination = new Pagination([
            'defaultPageSize' => 10,
            'totalCount' => $query->count(),
        ]);

        $all = $query->orderBy('role desc')
            ->offset($pagination->offset)
            ->limit($pagination->limit)
            ->all();

        $count = ($pagination->getPage() + 1) > 1 ? ($pagination->getPage() + 1) * 10 - 9 : 1;

        return $this->render('admin',
            [
                'pagination' => $pagination,
                'all' => $all,
                'count' => $count,
                'count_query' => $query->count(),
            ]

        );


    }


    public function actionRef()
    {


        $query = User:: find()->where(['ref' => Yii::$app->user->id]);

        $pagination = new Pagination([
            'defaultPageSize' => 10,
            'totalCount' => $query->count(),
        ]);

        $all = $query->orderBy('id desc')
            ->offset($pagination->offset)
            ->limit($pagination->limit)
            ->all();

        $count = ($pagination->getPage() + 1) > 1 ? ($pagination->getPage() + 1) * 10 - 9 : 1;

        return $this->render('ref',
            [
                'pagination' => $pagination,
                'all' => $all,
                'count' => $count,
                'count_query' => $query->count(),
            ]

        );


    }

    public function actionSearch()
    {

        return $this->render('search');

    }

    public function actionGift($user_id)
    {

        $who = User:: findOne($user_id);

        if (!isset($who->id)) return $this->goHome();

        $user = User:: findOne(Yii::$app->user->id);

        if ($user->id == $who->id) return $this->goHome();


        $query = Gift:: find();

        $pagination = new Pagination([
            'defaultPageSize' => 10,
            'totalCount' => $query->count(),
        ]);

        $gifts = $query->orderBy('id desc')
            ->offset($pagination->offset)
            ->limit($pagination->limit)
            ->all();

        return $this->render('gift', ['who' => $who,
            'gifts' => $gifts,
            'pagination' => $pagination,
        ]);

    }


    public function actionGiftTo($user_id = null, $gift_id = null)
    {

        $who = User:: findOne($user_id);

        if (!isset($who->id)) return $this->goHome();

        $user = User:: findOne(Yii::$app->user->id);

        if ($user->id == $who->id) return $this->goHome();

        $gift = Gift:: findOne($gift_id);

        if (!isset($gift->id)) return $this->goHome();

        $model = new \app\models\form\GiftTo();

        if ($model->load(Yii::$app->request->post()) && $model->validate()) {

            if ($user->ruby < $gift->price) {

                User:: Notice(['status' => 'error', 'title' => 'Недостаточно рубинов']);
                return $this->redirect('/user/gift-to/' . $who->id . '/' . $gift->id);

            }

            $usgift = new Giftuser();
            $usgift->user = $who->id;
            $usgift->who = $user->id;
            $usgift->comment = empty($model->comment) ? null : $model->comment;
            $usgift->gift = $gift->id;
            $usgift->save();

            User:: AchievementsSet($user->id, 4, User:: Achievements($user->id, 4) + 1);

            User:: Notice(['status' => 'success', 'title' => 'Подарок успешно отправлен']);
            return $this->redirect('/user/' . $who->id);

        }


        return $this->render('gift-to', ['who' => $who,
            'gift' => $gift,
            'model' => $model,
        ]);

    }


    public function actionGiftList($user_id)
    {

        $user = User:: findOne($user_id);

        if (!isset($user->id)) return $this->goHome();

        $query = Giftuser:: find()->where(['user' => $user->id]);

        $pagination = new Pagination([
            'defaultPageSize' => 10,
            'totalCount' => $query->count(),
        ]);

        $all = $query->orderBy('id desc')
            ->offset($pagination->offset)
            ->limit($pagination->limit)
            ->all();


        return $this->render('gift-list', ['all' => $all,
            'count' => $query->count(),
            'pagination' => $pagination,
            'user' => $user,
        ]);

    }


    public function actionExchange($get = null)
    {

        $user = User:: findOne(Yii::$app->user->id);

        $exchange = [100 => $user->income * 3600 * 12,
            200 => $user->income * 3600 * 24,
            400 => $user->income * 3600 * 48,
            800 => $user->income * 3600 * 98,
            1600 => $user->income * 3600 * 192,
            3200 => $user->income * 3600 * 384,
            6400 => $user->income * 3600 * 768,
        ];

        $exchange = \app\models\active\Action:: Week() == 4 ? [50 => $user->income * 3600 * 12,
            100 => $user->income * 3600 * 24,
            200 => $user->income * 3600 * 48,
            400 => $user->income * 3600 * 98,
            800 => $user->income * 3600 * 192,
            1600 => $user->income * 3600 * 384,
            3200 => $user->income * 3600 * 768,
        ] : $exchange;

        if (isset($get)) {

            if (!in_array($get, array_keys($exchange))) return $this->redirect('/user/exchange');

            if ($user->ruby < $get) {

                User:: Notice(['title' => 'Недостаточно рубинов', 'status' => 'error']);
                return $this->redirect('/user/exchange');

            }


            $user->ruby = $user->ruby - $get;
            $user->money = $user->money + $exchange[$get];
            $user->save();

            if (User:: Achievements($user->id, 12) < 3000) {
                User:: AchievementsSet($user->id, 12, User:: Achievements($user->id, 12) + $get);
            }

            User:: QuestSet(5, 1, 1);

            User:: Notice(['title' => 'Обмен успешно произведен', 'status' => 'success']);
            return $this->redirect('/user/exchange');
        }


        return $this->render('exchange', ['exchange' => $exchange]);

    }


    public function actionChests()
    {

        $user = User:: findOne(Yii::$app->user->id);

        $lucky = User:: find()->where(['>', 'lucky', 0])->orderBy('lucky desc')->limit(5);

        return $this->render('chests', ['user' => $user, 'lucky' => $lucky, 'count' => 1]);


    }


    public function actionAchievements($id = null, $value = null)
    {

        $user = User:: findOne($id ?? Yii::$app->user->id);

        if (!isset($user->id)) return $this->goHome();

        $setting = Setting:: findOne(1);


        $array = [
            1 => 25000,
            2 => 1000,
            3 => 15,
            4 => 50,
            5 => 3,
            6 => 15000,
            7 => 12,
            8 => 500000,
            9 => 50,
            10 => 10,
            11 => 10,
            12 => 3000
        ];

        $arrayName = [
            1 => 'Чемпион',
            2 => 'Космический пират',
            3 => 'Небоскрёб',
            4 => 'Добряк',
            5 => 'Житель Марса',
            6 => 'Ювелир',
            7 => 'Добытчик',
            8 => 'Магнат',
            9 => 'Все сначала',
            10 => 'Общительный',
            11 => 'Успешный бизнесмен',
            12 => 'Мажор'
        ];

        if (isset($value)) {

            if (!in_array($value, [1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12])) return $this->goHome();

            if (User:: AchievementsDone($user->id, $value, $array[$value])) {

                $user->ruby = $user->ruby + 1000;
                $user->cup = $user->cup + $setting->achievements_cup;
                $user->save();

                if (User:: Achievements($user->id, 1) < 25000) {
                    User:: AchievementsSet($user->id, 1, User:: Achievements($user->id, 1) + $setting->achievements_cup);
                }

                $ach = Achievements:: findOne(['type' => $value, 'user' => $user->id]);
                $ach->reward = 1;
                $ach->save();

                $chat = new Chat();
                $chat->user = 2;
                $chat->text = 'Игрок ' . User:: findUser($user->id) . ' получил достижение <b style="color:yellow;">' . $arrayName[$value] . '</b> ' . Html::a('Подарить подарок', ['/user/gift/' . $user->id], ['class' => 'btn']);
                $chat->save();

                User:: Notice(['title' => 'Достижение получено', 'status' => 'success']);

                return $this->redirect('/user/achievements');

            }

        }

        return $this->render('achievements', ['user' => $user, 'setting' => $setting]);

    }


    public function actionQuest($value = null)
    {


        Quest:: deleteAll(['AND', ['user' => Yii::$app->user->id], ['<', 'time', time()]]);

        $price = \app\models\active\Action:: Week() == 6 ? 50 : 25;

        $price_all = \app\models\active\Action:: Week() == 6 ? 100 : 50;

        $setting = Setting:: findOne(1);

        if (isset($value)) {
            if (in_array($value, range(1, 9))) {

                $array = [1 => 50, 2 => 3, 3 => 1, 4 => 300, 5 => 1, 6 => 9999999, 7 => 1800, 8 => 5, 9 => 1];

                if (User:: QuestDone($value, $array[$value])) {

                    $quest = Quest:: findOne(['user' => Yii::$app->user->id, 'type' => $value]);
                    $quest->price = 1;
                    $quest->save();

                    $key = $value == 9 ? 10 : 3;
                    $cup = $value == 9 ? $setting->quest_price_cup_all : $setting->quest_price_cup;
                    $ruby = $value = 9 ? $price_all : $price;

                    $user = User:: findOne(Yii::$app->user->id);

                    if ($user->vip >= time()) {
                        $cup = $cup * 2;
                        $ruby = $ruby * 2;
                    }

                    if (User:: Achievements($user->id, 1) < 25000) {
                        User:: AchievementsSet($user->id, 1, User:: Achievements($user->id, 1) + $cup);
                    }

                    $user->ruby = $user->ruby + $ruby;
                    $user->_key = $user->_key + $key;
                    $user->cup = $user->cup + $cup;
                    $user->save();

                }

            }

        }

        return $this->render('quest', ['price' => $price,
            'price_all' => $price_all,
            'setting' => $setting
        ]);

    }

    public function actionJournal()
    {
        $user = User::findOne(Yii::$app->user->id);

        $query = Journal::find()->where(['user_id' => $user->id]);

        $pagination = new Pagination([
            'defaultPageSize' => 10,
            'totalCount' => $query->count()
        ]);

        Journal::updateAll(['read' => '0'], ['user_id' => $user->id, 'read' => '1']);

        $lists = $query->orderBy('time desc')
            ->offset($pagination->offset)
            ->limit($pagination->limit)
            ->all();

        return $this->render('journal', [
            'action' => null,
            'lists' => $lists,
            'pagination' => $pagination
        ]);
    }

    public function actionUpdateItem($type): Response
    {
        $user = User::findOne(Yii::$app->user->id);

        if (!isset($user->id)) return $this->goHome();
        //-- Настройки вещей
        $config = Yii::$app->params['items_param'];

        if (empty($config)) {
            return $this->goHome();
        } else {
            if (!in_array($type, $config['types'])) {
                return $this->goHome();
            } else {
                //-- Ищем вещь
                $item = Items::find()->where(['type' => $type, 'user_id' => $user->id])->one();

                if (empty($item)) {
                    $item = new Items();
                    $item->type = $type;
                    $item->user_id = $user->id;
                    $item->level = 0;
                    $item->param = 0;
                    $item->save();
                }

                if ($user->ruby < $config['param'][$item['level']]['cost']) {
                    User::Notice(['title' => 'Недостаточно рубинов', 'status' => 'error']);
                    return $this->redirect('/user/' . $user->id);
                } elseif ($item->level == $config['max_level']) {
                    User::Notice(['title' => 'Максимальный уровень вещи', 'status' => 'error']);
                    return $this->redirect('/user/' . $user->id);
                } else {
                    $user->ruby = $user->ruby - $config['param'][$item['level']]['cost'];
                    $user->strike = $user->strike + $config['param'][$item['level']]['params'];
                    $user->defend = $user->defend + $config['param'][$item['level']]['params'];
                    $user->health = $user->health + $config['param'][$item['level']]['params'];
                    $user->save();

                    $item->level = $item->level + 1;
                    $item->save();

                    User::Notice(['title' => 'Вещь успешно улучшена +'.($config['param'][($item['level'] - 1)]['params']).' к параметрам', 'status' => 'success']);
                    return $this->redirect('/user/' . $user->id);
                }
            }
        }
    }

    /**
     * Маршрут для сброса биснесов
     * @author OlegKulaga (Medan)
     * -- Убрал по тз
     * -- Перенесено в профиль юзера
     * -- TODO: Убрать при не надобности
     */
    /*
    public function actionDumpBusiness($dump = null)
    {
        $user = User:: findOne(Yii::$app->user->id);

        if (!empty($user)) {
            $count = (int)Mybusiness::find()->where(['user' => $user->id])->count();
            $cost = $count * 100;

            if (!empty($dump)) {
                if ($cost < 1) {
                    User:: Notice(['title' => 'Вы не получаете доход', 'status' => 'error']);
                    return $this->redirect('/user/dump-business');
                } elseif ($count < 15) {
                    User:: Notice(['title' => 'Доступно после наличия 15 бизнесов. У вас '. $count.'.', 'status' => 'error']);
                    return $this->redirect('/user/dump-business');
                }
                else {
                    $business = Mybusiness :: find()->where(['user' => $user->id])->one();

                    if (!empty($business)) {
                        if (User:: Achievements($user->id, 9) < 50) {
                            User:: AchievementsSet($user->id, 9, User:: Achievements($user->id, 9) + $count);
                        }
                        $user->cup = $user->cup + $cost;
                        $user->save();
                        Mybusiness::deleteAll(['user' => $user->id]);

                        if (User:: Achievements($user->id, 11) < 10) {
                            User:: AchievementsSet($user->id, 11, 0);
                        }

                        User:: Notice(['title' => 'Все бизнесы успешно сброшены', 'status' => 'success']);
                        return $this->redirect('/user/dump-business');
                    } else {
                        User:: Notice(['title' => 'У вас нет активных бизнесов', 'status' => 'error']);
                        return $this->redirect('/user/dump-business');
                    }
                }
            } else {
                return $this->render('dump-business', [
                    'cost' => $cost,
                    'count' => $count
                ]);
            }
        } else {
            return $this->goHome();
        }
    }
    */

}